using System.Data;
using System.Data.SqlClient;
using System.Reflection;
using STOREDPROC = gov.va.med.vbecs.Common.VbecsStoredProcs;
using gov.va.med.vbecs.Common;

namespace gov.va.med.vbecs.DAL
{
		#region Header

		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/17/2003</CreationDate>
		///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		///<summary>
		/// Data access component implementing data persistence logic for testing status.
		/// Allows retrieval of testing status data from database.
		/// </summary>

		#endregion

	public class TestingStatus 
	{

		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/17/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1297"> 
		///		<ExpectedInput>None</ExpectedInput>
		///		<ExpectedOutput>Data table of testing statuses.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1328"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		///  Retrieves all available testing statuses to be used in testing status lookup list
		/// </summary>
		/// <returns>DataTable containing testing statuses (ID/text pairs)</returns>
		public static DataTable GetTestingStatusLookupList()
		{
			DataSet ds = Common.StoredProcedure.GetData(STOREDPROC.GetTestingStatusLookupList.StoredProcName);

			return ds.Tables[0];
		}

		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/18/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1966"> 
		///		<ExpectedInput>Testing status ID</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1967"> 
		///		<ExpectedInput>Invalid testing status ID</ExpectedInput>
		///		<ExpectedOutput>DataAccessLayerExcpetion</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Returns the testing status text based on the testing status ID
		/// </summary>
		/// <param name="testingStatusID">Testing status ID</param>
		/// <returns>Testing status text</returns>
		public static string GetTestingStatusTextFromID(int testingStatusID)
		{
			SqlParameter[] prms =	
			{
				new SqlParameter(STOREDPROC.GetTestingStatusTextFromID.TestingStatusId, System.Data.SqlDbType.Int)
			};
			prms[0].Value = testingStatusID;

			DataTable dtTestingStatusText = Common.StoredProcedure.GetData(STOREDPROC.GetTestingStatusTextFromID.StoredProcName, prms).Tables[0];

			//Check # of rows
			switch (dtTestingStatusText.Rows.Count)
			{
				case 0:
					throw new Common.DataAccessLayerException(Common.StrRes.SysErrMsg.Common.NoDataRowsFoundException(
						Common.Utility.ParseStringwithSpaces(MethodBase.GetCurrentMethod().Name)).ResString);

				case 1:
					DataRow drTestingStatusText  = dtTestingStatusText.Rows[0];
					string testingStatusText = drTestingStatusText.IsNull("TestingStatusText") ? string.Empty : (string) drTestingStatusText["TestingStatusText"];
					return testingStatusText;

				default:
					string errorMessage = Common.StrRes.SysErrMsg.Common.TooManyDataRowsFoundException(
						Common.Utility.ParseStringwithSpaces(MethodBase.GetCurrentMethod().Name)).ResString;
					throw new DataAccessLayerException(errorMessage);
			}
		}
	}
}
